<?php
class PortalFront extends Portal
{
  public $zalogowany = null;
  
  function __construct($host, $user, $pass, $db)
  {
    $this->dbo = $this->initDB($host, $user, $pass, $db);
    $this->zalogowany = $this->getActualUser();
  }
  
  function getActualUser()
  {
    if(isset($_SESSION['zalogowany'])){
      return $_SESSION['zalogowany'];
    }
    else{
      return null;
    }
  }
  
  function setMessage($komunikat)
  {
    $_SESSION['komunikat'] = $komunikat;
  }
  
  function getMessage()
  {
    if(isset($_SESSION['komunikat'])){
      $komunikat = $_SESSION['komunikat'];
      unset($_SESSION['komunikat']);
      return $komunikat;
    }
    else {
      return null;
    }
  }

  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy użytkownik już jest zalogowany
    if($this->zalogowany){
      return NO_LOGIN_REQUIRED;
    }
    
    //Sprawdzenie czy zostały przekazane parametry
    if(!isset($_POST["email"]) || !isset($_POST["haslo"])){
      return FORM_DATA_MISSING;
    }
    
    $user = $_POST["email"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie długości przekazanych ciągów
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    //$userNameLength = strlen(utf8_decode($user));
    //$userPassLength = strlen(utf8_decode($pass));
    //lub
    $userEmailLength = mb_strlen($user, 'utf8');
    $userPassLength = mb_strlen($pass, 'utf8');
    
    if($userEmailLength < 5 || $userEmailLength > 250 ||
     $userPassLength < 6 || $userPassLength > 100){
      return ACTION_FAILED;
    }
  
    //Zabezpieczenie znaków specjalnych w parametrach
    $email = $this->dbo->real_escape_string($user);
    $pass = $this->dbo->real_escape_string($pass);
    
    //Wykonanie zapytania sprawdzającego poprawność danych
    $query = "SELECT `Id`, `Imię`, `Nazwisko`, `Hasło` "
           . "FROM Klienci WHERE `Email`='$email'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wyników zapytania.
    if($result->num_rows <> 1){
      //Brak użytkownika o wskazanej nazwie lub zbyt wiele wyników
      return ACTION_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[3];
      //Wersja bez kodowania haseł
      if($pass != $pass_db){
      //Wersja z kodowaniem haseł
      //if(crypt($pass, $pass_db) != $pass_db){
        return ACTION_FAILED;
      }
      else{
        $nazwa = $row[1] . ' ' . $row[2];
        $_SESSION['zalogowany'] = new User($row[0], $nazwa);
        return ACTION_OK;
      }
    }
  }
  
  function logout()
  {
    //Treść meotdy logout
  }
  
  //Tutaj pozostałe metody klasy
}
?>